/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.asistentes.modifiers.ventas;

import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidableAnotado;
import ec.gob.sri.dimm.api.modelo.validacion.EstadoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.ui.asistentes.PaginaAsistente;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.Compensacion;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;

public class CompensacionCellModifier
implements ICellModifier {
    private final ObjetoModelo modeloDatos;
    private final PaginaAsistente paginaAsistente;

    public CompensacionCellModifier(ObjetoModelo modeloDatos, PaginaAsistente paginaAsistente) {
        this.modeloDatos = modeloDatos;
        this.paginaAsistente = paginaAsistente;
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        String result = null;
        Compensacion compensacion = (Compensacion)element;
        result = String.valueOf(compensacion.getMonto());
        return result;
    }

    public void modify(Object element, String property, Object value) {
        TableItem item = (TableItem)element;
        Compensacion compensacion = (Compensacion)item.getData();
        String monto = ((String)value).trim();
        compensacion.setMonto(monto);
        this.ejecutarValidaciones();
    }

    private void ejecutarValidaciones() {
        ObjetoModeloSucesorValidableAnotado modeloValidable = (ObjetoModeloSucesorValidableAnotado)this.modeloDatos;
        ResultadoValidacion resultado = modeloValidable.validar();
        boolean exitoso = resultado.esEstadoExitoso();
        if (exitoso) {
            this.paginaAsistente.setErrorMessage(null);
            this.paginaAsistente.setMessage(null);
            this.paginaAsistente.setPageComplete(true);
            return;
        }
        if (resultado.getEstado() == EstadoValidacion.FALLIDO) {
            this.paginaAsistente.setMessage(null);
            this.paginaAsistente.setErrorMessage(resultado.getMensaje());
            this.paginaAsistente.setPageComplete(false);
        } else if (resultado.getEstado() == EstadoValidacion.ADVERTENCIA) {
            this.paginaAsistente.setErrorMessage(null);
            this.paginaAsistente.setMessage(resultado.getMensaje(), 2);
            this.paginaAsistente.setPageComplete(true);
        }
    }
}

